<!doctype html>
<html>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <script src="https://cdn.tailwindcss.com"></script>
    <title>Admin</title>
</head>
<body>
<div class="grid place-items-center h-screen">
    <form method="POST" action = "<?php echo e(route('admin.add.price')); ?>" class="rounded-md shadow-md p-4 w-1/3">
        <?php echo csrf_field(); ?>
        <?php if(session()->has('success')): ?>
            <div class="p-4 bg-green-500 text-white w-full rounded-md">
                <?php echo e(session()->get('success')); ?>

            </div>
            <div class="pb-2"></div>
        <?php endif; ?>
        <?php if(session()->has('error')): ?>
            <div class="p-4 bg-red-500 text-white w-full rounded-md">
                <?php echo e(session()->get('error')); ?>

            </div>
            <div class="pb-2"></div>
        <?php endif; ?>
        <span class="text-lg">Add Price</span>
        <div class="pt-4"></div>
        <div class="grid gap-4">
            <div class="grid gap-2">
                <label for="service">Service</label>
                <select id="service" name="service" class="rounded-md p-3 border">
                    <?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($service->id); ?>"><?php echo e($service->service); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="grid gap-2">
                <label for="country">Country</label>
                <select id="country" name="country" class="rounded-md p-3 border">
                    <?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($country->id); ?>"><?php echo e($country->country); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="grid gap-2">
                <label for="price">Price</label>
                <input type="number" name="price" id="price" class="rounded-md border p-3" />
                <?php $__errorArgs = ['price'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>
            <div>
                <button type="submit" class="bg-blue-500 rounded-md px-4 py-2 text-white">Add</button>
            </div>
        </div>
    </form>
</div>
</body>
</html>
<?php /**PATH /Users/apple/Documents/Development/smsgetter/resources/views/admin/home.blade.php ENDPATH**/ ?>