<?php

use App\Http\Controllers\ProfileController;
use App\Http\Controllers\SmsController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/', function () {
    return view('welcome');
});

Route::get('/dashboard', [SmsController::class, 'index'])->middleware(['auth', 'verified'])->name('dashboard');
Route::post('/dashboard/buy', [SmsController::class, 'getNumber'])->middleware(['auth', 'verified'])->name('buy');
Route::get('/dashboard/messages', [SmsController::class, 'getMessagePage'])->middleware(['auth', 'verified'])->name('messages');
Route::post('/dashboard/messages', [SmsController::class, 'getMessage'])->middleware(['auth', 'verified'])->name('get.messages');

Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});

Route::prefix('admin')->group(function() {
    Route::get('login', [\App\Http\Controllers\AdminController::class, 'login'])->name('admin.login');
    Route::post('login', [\App\Http\Controllers\AdminController::class, 'processLogin'])->name('admin.post.login');
    Route::get('home', [\App\Http\Controllers\AdminController::class, 'admin'])->name('admin.home');
    Route::post('add/price', [\App\Http\Controllers\AdminController::class, 'addPrice'])->name('admin.add.price');
});

require __DIR__ . '/auth.php';
