<div>
    <div class="w-[600px] bg-white rounded-md shadow-md p-5">
        @csrf
        <div wire:poll>
            Your number:  {{ $number  }}
        </div>
        <div wire:poll>
            @if (session()->has('success'))
            <div class="bg-green-500 text-white p-3 rounded-md">
                {{ session()->get('success') }}
            </div>
            @endif
            @if (session()->has('error'))
            <div class="bg-red-500 text-white p-3 rounded-md">
                {{ session()->get('error') }}
            </div>
            @endif
        </div>
        <div class="flex justify-center">
            <span class="text-xl font-semibold underline"> Buy Number </span>
        </div>
        <div class="pt-4">
            <span>Select Country</span>
            <div class="pt-3"></div>
            <select wire:model="selectedCountry" class="w-full rounded-md">
                @foreach ($countries as $country)
                <option value="{{ $country['code'] }}"> {{ $country['name'] }} </option>
                @endforeach
            </select>
        </div>
        <div class="pt-4">
            <span>Select Service</span>
            <div class="pt-3"></div>
            <select wire:model="selectedService" class="w-full rounded-md">
                <option value="" selected>Please select</option>
                @foreach ($services as $service)
                <option value="{{ $service['service'] }}"> {{ $service['service'] }} </option>
                @endforeach
            </select>
            <div wire:poll="getValue">
                Price - {{ $price }}
            </div>
        </div>
        <div class="pt-5">
            <button class="bg-blue-500 text-white rounded-md px-5 py-2" wire:loading.class="opacity-50" wire:click="process">Buy</button>
        </div>
    </div>
</div>
