<!doctype html>
<html>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <script src="https://cdn.tailwindcss.com"></script>
    <title>Admin</title>
</head>
<body>
<div class="grid place-items-center h-screen">
    <form method="POST" action = "{{ route('admin.add.price')  }}" class="rounded-md shadow-md p-4 w-1/3">
        @csrf
        @if(session()->has('success'))
            <div class="p-4 bg-green-500 text-white w-full rounded-md">
                {{ session()->get('success') }}
            </div>
            <div class="pb-2"></div>
        @endif
        @if(session()->has('error'))
            <div class="p-4 bg-red-500 text-white w-full rounded-md">
                {{ session()->get('error') }}
            </div>
            <div class="pb-2"></div>
        @endif
        <span class="text-lg">Add Price</span>
        <div class="pt-4"></div>
        <div class="grid gap-4">
            <div class="grid gap-2">
                <label for="service">Service</label>
                <select id="service" name="service" class="rounded-md p-3 border">
                    @foreach($services as $service)
                    <option value="{{ $service->id }}">{{ $service->service }}</option>
                    @endforeach
                </select>
            </div>
            <div class="grid gap-2">
                <label for="country">Country</label>
                <select id="country" name="country" class="rounded-md p-3 border">
                    @foreach($countries as $country)
                        <option value="{{ $country->id }}">{{ $country->country }}</option>
                    @endforeach
                </select>
            </div>
            <div class="grid gap-2">
                <label for="price">Price</label>
                <input type="number" name="price" id="price" class="rounded-md border p-3" />
                @error('price') <span class="text-red-500">{{ $message }}</span> @enderror
            </div>
            <div>
                <button type="submit" class="bg-blue-500 rounded-md px-4 py-2 text-white">Add</button>
            </div>
        </div>
    </form>
</div>
</body>
</html>
