<?php

namespace App\Livewire;

use App\Models\Amount;
use App\Models\Country;
use App\Models\Numbers;
use App\Models\Service;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;
use Livewire\Component;

class Services extends Component
{

    public $selectedService = NULL;
    public $selectedCountry = NULL;
    public $pservice;
    public $countries;
    public $services;
    public $numbers;
    public $price = 0;
    public $sService;
    public $sCountry;
    public $pickedService;
    public $pickedCountry;
    public $number;

    public function mount()
    {
        $response = Http::get('https://onlinesim.io/api/getTariffs.php', [
            'apikey' => '04b9bdc115f56885e91181404e52ce2c',
            'lang' => 'en',
        ]);
        $this->countries = $response['countries'];
        $this->services = $response['services'];

        $getNumbers = Numbers::whereUserId(auth()->id())->latest()->get();

        $this->numbers = $getNumbers;

        // get all service
        // foreach($this->services as $s){
        //     Service::create([
        //         'service' => $s['service']
        //     ]);
        // }

        // get all country
        // foreach($this->countries as $c) {
        //     Country::create([
        //         'country' => $c['name'],
        //         'code' => $c['code']
        //     ]);
        // }
    }

    public function render()
    {
        return view(
            'livewire.services',
        );
    }

    public function getValue()
    {
        if (!is_null($this->selectedCountry) && !is_null($this->selectedService)) {
            $ser = Service::whereService($this->selectedService)->first();
            $this->sService = $ser->id;
            $this->pickedService = $this->selectedService;

            $co = Country::whereCode($this->selectedCountry)->first();
            $this->sCountry = $co->id;
            $this->pickedCountry = $this->selectedCountry;

            $getService = Amount::whereServiceId($this->sService)->whereCountryId($this->sCountry)->first();
            $this->price = $getService->amount ?? 0;
        }
    }

    public function process()
    {
        if (!is_null($this->selectedCountry) && !is_null($this->selectedService)) {
            // ddd($this->pickedService . ' ' . $this->pickedCountry);
            $response = Http::get('https://onlinesim.io/api/getNum.php', [
                'apikey' => '04b9bdc115f56885e91181404e52ce2c',
                'service' => (string)$this->pickedService,
                'country' => (int)$this->pickedCountry,
                'number' => true
            ]);

            $this->number = $response['number'];

            // dd($response['response']);
            $purchase = Numbers::create([
                'number' => $response['number'],
                'tzid' => $response['tzid'],
                'country' => $response['country'],
                'user_id' => auth()->id(),
            ]);

            if ($purchase) {
                session()->flash('success', 'Number purchased successfully');
            } else {
                session()->flash('error', 'Error getting number');
            }
        } else {
            session()->flash('error', 'Select service and country');
        }
    }
}
