<?php

namespace App\Livewire;

use App\Models\Numbers;
use Illuminate\Http\Request;
use Livewire\Component;
use Illuminate\Support\Facades\Http;

class GetNumbers extends Component
{
    public $numbers;
    public $message;

    public function mount()
    {
        $this->numbers = Numbers::whereUserId(auth()->id())->latest()->get();
    }

    public function render()
    {
        return view('livewire.get-numbers');
    }

    public function getMessage(Request $request)
    {

//       get numbers
        $numbers = Numbers::whereUserId(auth()->id())->get();
        foreach ($numbers as $number) {
            $response = Http::get('https://onlinesim.io/api/getState.php', [
                'apikey' => '04b9bdc115f56885e91181404e52ce2c',
                'tzid' => (int)$number->tzid,
                'message_to_code' => 0,
            ]);
            if (empty($response[0]['response'])) {
                $this->message =  'No message or Number has expired';
            }
            if ($response['response'] == 'TZ_NUM_ANSWER') {
                $data = $response['msg'];
                $this->message = $data;
            } else {
                $this->message =  'No message or Number has expired';
            }
        }
    }
}
