<?php

namespace App\Http\Controllers;

use App\Models\Amount;
use App\Models\Country;
use App\Models\Service;
use Illuminate\Http\Request;

class AdminController extends Controller
{
    public function login(Request $request)
    {
        return view('admin.login');
    }

    public function processLogin(Request $request)
    {
        if($request->code == getenv('CODE'))
        {
            session()->put('admin', true);
            return redirect()->route('admin.home');
        }else{
            return back()->with('error', 'Invalid pin code');
        }
    }

    public  function admin()
    {
        if (session()->get('admin') == false) {
            return back();
        }
        $services = Service::all();
        $countries = Country::all();
        return view('admin.home', compact('services', 'countries'));
    }

    public function addPrice(Request $request)
    {
        $request->validate([
            'price' => 'required'
        ]);
        $amount = Amount::whereServiceId($request->service)->whereCountryId($request->country)->first();
        if($amount){
            Amount::whereServiceId($request->service)->whereCountryId($request->country)->update([
                'amount' => $request->price
            ]);
            return back()->with('success', "Price Added");
        }else{
            Amount::create([
                'service_id' => $request->service,
                'country_id' => $request->country,
                'amount' => $request->price
            ]);
            return back()->with('success', "Price Added");
        }
    }
}
